define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service("connectionTimeoutService", function ($http, $timeout, $modal, unsavedWarningSharedService, resourceDirectory,
													  authenticationService) {
		var service = {};

		var timeToExpire,
			timeUnitsText = "minutes",
			timeUnitText = "minute",
			oneMinute = 60000,
			twoMinutes = 2 * oneMinute,
			threeMinutes = 3 * oneMinute,
			conversionFactor = 1000,
			sessionEnded = false,
			timeoutPromise,
			modalInstance,
			modalInfo = {value: null, dismissed: true};

		var timeoutDialogController = function () {
			var waitTime;
			resourceDirectory.fetch().then(function (directory) {
				$http.get(directory['last-accesstime'], {background : true})
					.then(function (promise) {
						timeToExpire = promise.data.timeToExpireInSeconds * conversionFactor;

						if (timeToExpire <= threeMinutes) {
							showTimeoutWarning(timeToExpire);
							waitTime = timeToNearestMinute(timeToExpire);
						}
						else {
							dismissModal();
							waitTime = timeToExpire - threeMinutes;
						}

						if (!sessionEnded) {
							$timeout.cancel(timeoutPromise);
							timeoutPromise = $timeout(function () {
								timeoutDialogController();
							}, waitTime, false);
						}
					});
			});
		};

		function timeToNearestMinute(timeToExpire) {
			if (timeToExpire > threeMinutes) {
				return timeToExpire - threeMinutes;
			} else if (timeToExpire > twoMinutes) {
				return timeToExpire - twoMinutes;
			} else if (timeToExpire > oneMinute) {
				return timeToExpire - oneMinute;
			} else {
				return timeToExpire;
			}
		}

		var dismissModal = function () {
			if (angular.isDefined(modalInstance) && !modalInfo.dismissed) {
				modalInfo.dismissed = true;
				modalInstance.dismiss();
			}
		};

		var openModal = function (template, controller, modalInfo) {
			dismissModal();

			modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					}
				}
			});
		};

		var showTimeoutWarning = function (timeToExpire) {
			var minutesToExpire = Math.round(parseInt(timeToExpire, 10) / oneMinute);

			if (minutesToExpire <= 0) {
				sessionEnded = true;
				authenticationService.wipeSessionData();

				openModal('src/core/connection/session_ended_template.html', ModalInstanceCtrl, modalInfo);
				angular.element("div.container-fluid").remove();
			}
			else {
				modalInfo.value = minutesToExpire;
				modalInfo.unit = modalInfo.value !== 1 ? timeUnitsText : timeUnitText;
				openModal('src/core/connection/timeout_warning_template.html', ModalInstanceCtrl, modalInfo);
			}
		};

		service.run = function () {
			timeoutDialogController();
		};

		service.showSessionEndedMsg = function () {
			sessionEnded = true;
			unsavedWarningSharedService.cleanAllForms();

			angular.element("div.container-fluid").remove();
			openModal('src/core/connection/session_ended_template.html', ModalInstanceCtrl, modalInfo);
		};

		return service;
	});
});

function ModalInstanceCtrl($scope, $http, $timeout, $modalInstance, modalInfo, authenticationService, resourceDirectory, focusService) {
	modalInfo.dismissed = false;

	$timeout(function () {
		focusService.focusTopModal();
	}, 600);

	$scope.logout = function () {
		$modalInstance.dismiss();
		authenticationService.logoutRedirectToLaunchpad();
	};
	$scope.proceed = function () {
		$modalInstance.dismiss();
		resourceDirectory.fetch().then(function (directory) {
			$http.get(directory['mhpuser']);
		});
		modalInfo.dismissed = true;
		$modalInstance.result.finally(function(){
			focusService.focusMain();
		});
	};
	$scope.launchpad = function () {
		$modalInstance.dismiss();
		authenticationService.logoutRedirectToLaunchpad();
	};
	$scope.login = function () {
		$modalInstance.dismiss();
		authenticationService.authenticate();
	};

	$scope.modalInfo = modalInfo;
}


